/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.explosive.blast;

import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.explosive.IExplosive;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.helper.MathUtility;
import com.builtbroken.mc.lib.transform.sorting.Vector3DistanceComparator;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.lib.world.edit.BlockEdit;
import com.builtbroken.mc.prefab.entity.selector.EntityDistanceSelector;
import com.builtbroken.mc.prefab.explosive.blast.Blast;
import com.builtbroken.mc.prefab.explosive.blast.BlastProfiler;
import com.builtbroken.mc.prefab.explosive.blast.BlastRunProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.Explosion;

public class BlastBasic<B extends BlastBasic>
extends Blast<B> {
    static DamageSource source = new DamageSource("blast").func_94540_d();
    static BlastProfiler profiler = new BlastProfiler();
    protected float energy = 0.0f;
    protected double radius = 0.0;
    protected Entity explosionBlameEntity;
    protected Explosion wrapperExplosion;
    protected List<IWorldEdit> postCallDestroyMethod = new ArrayList<IWorldEdit>();
    protected BlastRunProfile profile = profiler.run(this);

    @Override
    public void getEffectedBlocks(List<IWorldEdit> list) {
        HashMap<BlockEdit, Float> map = new HashMap<BlockEdit, Float>();
        this.profile.startSection("getEffectedBlocks");
        this.profile.startSection("Pathfinder");
        this.triggerPathFinder(map, new BlockEdit(this.world, this.x, this.y, this.z), this.energy);
        this.profile.endSection("Pathfinder");
        list.addAll(map.keySet());
        this.profile.startSection("Sorter");
        Collections.sort(list, new Vector3DistanceComparator(new Pos(this.x(), this.y(), this.z())));
        this.profile.endSection("Sorter");
        this.profile.endSection("getEffectedBlocks");
        if (Engine.runningAsDev) {
            Engine.instance.logger().info((Object)this.profile.getOutputSimple());
        }
    }

    protected void triggerPathFinder(HashMap<BlockEdit, Float> map, BlockEdit vec, float energy) {
        this.expand(map, vec, energy, null, 0);
    }

    protected void expand(HashMap<BlockEdit, Float> map, BlockEdit vec, float energy, EnumFacing side, int iteration) {
        long timeStart = System.nanoTime();
        if ((double)iteration < this.size * 2.0) {
            float e = this.getEnergyCostOfTile(vec, energy);
            ++this.profile.tilesPathed;
            if (e >= 0.0f) {
                vec.energy = energy;
                this.onBlockMapped(vec, e, energy - e);
                map.put(vec, Float.valueOf(energy - e));
                if (e > 1.0f) {
                    ArrayList<BlockEdit> sides = new ArrayList<BlockEdit>();
                    for (EnumFacing dir : EnumFacing.values()) {
                        if (dir == side) continue;
                        BlockEdit v = new BlockEdit(this.world, vec.x(), vec.y(), vec.z());
                        v.doDrops();
                        v = (BlockEdit)v.add(dir);
                        v.face = dir;
                        v.logPrevBlock();
                        sides.add(v);
                    }
                    Collections.sort(sides, new Vector3DistanceComparator(new Pos(this.x(), this.y(), this.z())));
                    this.profile.blockIterationTimes.add(System.nanoTime() - timeStart);
                    for (BlockEdit f : sides) {
                        EnumFacing face;
                        float eToSpend = e / (float)sides.size() + e % (float)sides.size();
                        e -= eToSpend;
                        EnumFacing enumFacing = face = side == null ? this.getOpposite(f.face) : side;
                        if (map.containsKey(f) && !(map.get(f).floatValue() < eToSpend)) continue;
                        f.face = face;
                        this.expand(map, f, eToSpend, face, iteration + 1);
                    }
                }
            }
        }
    }

    private EnumFacing getOpposite(EnumFacing face) {
        switch (face) {
            case UP: {
                return EnumFacing.DOWN;
            }
            case DOWN: {
                return EnumFacing.UP;
            }
            case NORTH: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.NORTH;
            }
            case EAST: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.EAST;
            }
        }
        return null;
    }

    protected float getEnergyCostOfTile(BlockEdit vec, float energy) {
        if (vec.isAirBlock(this.world)) {
            ++this.profile.airBlocksPathed;
        } else {
            ++this.profile.blocksRemoved;
        }
        return vec.getHardness() >= 0.0f ? energy - (float)Math.max((double)vec.getResistance(this.explosionBlameEntity, this.x, this.y, this.z), 0.5) : -1.0f;
    }

    @Override
    public void handleBlockPlacement(IWorldEdit vec) {
        Block block = vec.getBlock();
        if (vec.getNewBlock() == Blocks.field_150350_a || vec.getNewBlock() == Blocks.field_150480_ab) {
            if (!(block instanceof BlockTNT) && !(vec.getTileEntity() instanceof IExplosive)) {
                block.func_149723_a(this.world, (int)vec.x(), (int)vec.y(), (int)vec.z(), this.wrapperExplosion);
            } else {
                this.postCallDestroyMethod.add(vec);
            }
            vec.place();
        }
    }

    protected BlockEdit onBlockMapped(BlockEdit change, float energyExpended, float energyLeft) {
        if (energyExpended > energyLeft) {
            change.doItemDrop = true;
        }
        return change;
    }

    @Override
    public void doEffectOther(boolean beforeBlocksPlaced) {
        AxisAlignedBB bounds;
        List list;
        if (!beforeBlocksPlaced && (list = this.world.func_82733_a(Entity.class, bounds = AxisAlignedBB.func_72330_a((double)(this.x - this.size - 1.0), (double)(this.y - this.size - 1.0), (double)(this.z - this.size - 1.0), (double)(this.x + this.size + 1.0), (double)(this.y + this.size + 1.0), (double)(this.z + this.size + 1.0)), (IEntitySelector)new EntityDistanceSelector(new Pos(this.x, this.y, this.z), this.size + 1.0, true))) != null && !list.isEmpty()) {
            this.damageEntities(list, source);
        }
    }

    @Override
    public B setCause(TriggerCause cause) {
        super.setCause(cause);
        if (cause instanceof TriggerCause.TriggerCauseEntity) {
            this.explosionBlameEntity = ((TriggerCause.TriggerCauseEntity)cause).source;
        }
        if (this.explosionBlameEntity == null) {
            this.explosionBlameEntity = new EntityTNTPrimed(this.world);
            this.explosionBlameEntity.func_70107_b(this.x, this.y, this.z);
        }
        this.wrapperExplosion = new WrapperExplosion(this);
        return (B)this;
    }

    @Override
    public B setYield(double size) {
        super.setYield(size);
        this.radius = size;
        this.calcStartingEnergy();
        return (B)this;
    }

    protected void calcStartingEnergy() {
        this.energy = (float)(MathUtility.getSphereVolume(this.radius) * (double)this.eUnitPerBlock);
    }

    public static class WrapperExplosion
    extends Explosion {
        public final BlastBasic blast;

        public WrapperExplosion(BlastBasic blast) {
            super(blast.world(), blast.explosionBlameEntity, blast.x(), blast.y(), blast.z(), (float)blast.size);
            this.blast = blast;
        }
    }
}

