/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.recipe.fluid;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.prefab.recipe.extend.MachineRecipeLoader;
import com.builtbroken.mc.prefab.recipe.fluid.MRFluidStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class MRLoaderFluidStack
extends MachineRecipeLoader<MRFluidStack> {
    public MRLoaderFluidStack(String type) {
        super(type);
    }

    protected MRFluidStack newRecipe(Fluid fluid, int ingots, ItemStack input) {
        MRFluidStack recipe = new MRFluidStack(this.type, new FluidStack(fluid, ingots * Engine.INGOT_VOLUME));
        recipe.addInputOption(input);
        return recipe;
    }

    protected MRFluidStack newRecipe(FluidStack stack, ItemStack input) {
        MRFluidStack recipe = new MRFluidStack(this.type, stack);
        recipe.addInputOption(input);
        return recipe;
    }

    protected Fluid registerFluid(String name) {
        Fluid fluid = new Fluid(name);
        if (!FluidRegistry.registerFluid((Fluid)fluid) && FluidRegistry.getFluid((String)name) == null) {
            Engine.instance.logger().error("Failed to register fluid " + name + " with no fluid registered to name");
        }
        return FluidRegistry.getFluid((String)name);
    }

    protected Fluid registerMoltenFluid(String name) {
        Fluid fluid = new Fluid(name);
        fluid.setViscosity(16000);
        fluid.setLuminosity(12);
        if (!FluidRegistry.registerFluid((Fluid)fluid) && FluidRegistry.getFluid((String)name) == null) {
            Engine.instance.logger().error("Failed to register fluid " + name + " with no fluid registered to name");
        }
        return FluidRegistry.getFluid((String)name);
    }

    protected void processOreRecipes(List<MRFluidStack> recipes, Fluid output, int ingots, String input) {
        ArrayList oreList = OreDictionary.getOres((String)input);
        for (ItemStack stack : oreList) {
            if (stack == null || stack.func_77973_b() == null) continue;
            recipes.add(this.newRecipe(output, ingots, stack));
        }
    }
}

