/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.tile;

import com.builtbroken.mc.api.ISave;
import com.builtbroken.mc.api.IUpdate;
import com.builtbroken.mc.api.tile.ISided;
import com.builtbroken.mc.api.tile.ITileModuleProvider;
import com.builtbroken.mc.api.tile.node.ITileModule;
import com.builtbroken.mc.prefab.tile.TileMachine;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileModuleMachineBase
extends TileMachine
implements ITileModuleProvider {
    protected List<ITileModule> modules = new ArrayList<ITileModule>();

    public TileModuleMachineBase(String name, Material material) {
        super(name, material);
    }

    @Override
    public void onNeighborChanged(Block block) {
        super.onNeighborChanged(block);
        for (ITileModule node : this.getNodes()) {
            if (node == null) continue;
            node.onParentChange();
        }
    }

    @Override
    public void onWorldJoin() {
        super.onWorldJoin();
        for (ITileModule node : this.getNodes()) {
            if (node == null) continue;
            node.onJoinWorld();
        }
    }

    @Override
    public void update() {
        super.update();
        for (ITileModule node : this.getNodes()) {
            if (!(node instanceof IUpdate)) continue;
            ((IUpdate)((Object)node)).update();
        }
    }

    @Override
    public void func_145843_s() {
        for (ITileModule node : this.getNodes()) {
            if (node == null) continue;
            node.onLeaveWorld();
        }
        super.func_145843_s();
    }

    protected final List<ITileModule> getNodes() {
        return this.modules;
    }

    @Override
    public <N extends ITileModule> N getModule(Class<? extends N> nodeType, ForgeDirection from) {
        for (ITileModule module : this.getNodes()) {
            if (module instanceof ISided && !((ISided)((Object)module)).isValidForSide(from) || !nodeType.isAssignableFrom(module.getClass())) continue;
            return (N)module;
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (ITileModule node : this.getNodes()) {
            if (!(node instanceof ISave)) continue;
            ((ISave)((Object)node)).load(nbt);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (ITileModule node : this.getNodes()) {
            if (!(node instanceof ISave)) continue;
            ((ISave)((Object)node)).save(nbt);
        }
    }
}

