/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.tile.module;

import com.builtbroken.mc.api.IUpdate;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.tile.ITileModuleProvider;
import com.builtbroken.mc.api.tile.node.ITileModule;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.transform.vector.Pos;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileModule
implements ITileModule,
IWorldPosition,
IUpdate {
    private final ITileModuleProvider parent;
    private boolean[] canConnect = new boolean[]{true, true, true, true, true, true};

    public TileModule(ITileModuleProvider parent) {
        this.parent = parent;
        if (!(parent instanceof TileEntity)) {
            throw new IllegalArgumentException(this.getClass() + " requires that " + parent + " is an instanceof TileEntity");
        }
    }

    public boolean allowConnection(ForgeDirection side) {
        return side == ForgeDirection.UNKNOWN || this.canConnect[side.ordinal()];
    }

    public void setAllowConnection(ForgeDirection side, boolean t) {
        if (side != ForgeDirection.UNKNOWN) {
            this.canConnect[side.ordinal()] = t;
        }
    }

    @Override
    public boolean update() {
        return false;
    }

    @Override
    public void onJoinWorld() {
    }

    @Override
    public void onParentChange() {
    }

    @Override
    public void onLeaveWorld() {
    }

    public <N extends ITileModule> N getModule(Class<? extends N> nodeType, ForgeDirection from) {
        TileEntity tile = this.toLocation().getTileEntity();
        if (tile instanceof ITileModuleProvider) {
            return ((ITileModuleProvider)tile).getModule(nodeType, from);
        }
        return null;
    }

    @Override
    public ITileModuleProvider getParent() {
        return this.parent;
    }

    @Override
    public World world() {
        return ((TileEntity)this.parent).func_145831_w();
    }

    @Override
    public double x() {
        return ((TileEntity)this.parent).field_145851_c;
    }

    @Override
    public double y() {
        return ((TileEntity)this.parent).field_145848_d;
    }

    @Override
    public double z() {
        return ((TileEntity)this.parent).field_145849_e;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.hashCode() + "]";
    }

    public Location toLocation() {
        return new Location(this);
    }

    public Pos toPos() {
        return new Pos(this.x(), this.y(), this.z());
    }
}

