/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.handlers.nei;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.SearchField;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.api.ItemInfo;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ModNameFilter
implements SearchField.ISearchProvider {
    List<SearchField.ISearchProvider> searchProviders = new LinkedList<SearchField.ISearchProvider>();

    public ItemFilter getFilter(String searchText) {
        for (SearchField.ISearchProvider provider : SearchField.searchProviders) {
            if (provider.equals(this)) continue;
            this.searchProviders.add(provider);
        }
        return new Filter(searchText, this.searchProviders);
    }

    public static class Filter
    implements ItemFilter {
        String searchText;
        Pattern pattern;
        boolean oreDictSearch = false;
        List<SearchField.ISearchProvider> searchProviders = new LinkedList<SearchField.ISearchProvider>();

        public Filter(String searchText, List<SearchField.ISearchProvider> providers) {
            this.searchProviders = providers;
            this.searchText = searchText;
            switch (NEIClientConfig.getIntSetting((String)"inventory.searchmode")) {
                case 0: {
                    searchText = "\\Q" + searchText + "\\E";
                    break;
                }
                case 1: {
                    searchText = searchText.replace(".", "").replace("?", ".").replace("*", ".+?");
                }
            }
            try {
                if (searchText.startsWith("#") && searchText.length() > 1) {
                    this.pattern = Pattern.compile(searchText.substring(1));
                    this.oreDictSearch = true;
                } else {
                    this.pattern = Pattern.compile(searchText);
                    this.oreDictSearch = false;
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }

        public boolean matches(ItemStack item) {
            boolean result = true;
            try {
                for (SearchField.ISearchProvider provider : this.searchProviders) {
                    ItemFilter filter = provider.getFilter(this.searchText);
                    if (filter == null) continue;
                    result &= provider.getFilter(this.searchText).matches(item);
                }
                if (this.pattern == null || this.pattern.toString().equals("")) {
                    result &= true;
                } else if (!this.pattern.toString().startsWith("@")) {
                    if (this.oreDictSearch) {
                        int[] ids = OreDictionary.getOreIDs((ItemStack)item);
                        boolean found = false;
                        for (int id : ids) {
                            if (!this.pattern.matcher(OreDictionary.getOreName((int)id).toLowerCase()).find()) continue;
                            found = true;
                        }
                        result &= found;
                    } else {
                        result &= this.pattern.matcher(ItemInfo.getSearchName((ItemStack)item)).find() || this.pattern.matcher(ModIdentification.nameFromStack(item).toLowerCase()).find();
                    }
                }
            }
            catch (Exception e) {
                Waila.log.warn(String.format("Error while filtering items : %s : %s", e, e.getMessage()));
            }
            return result;
        }
    }
}

